/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.repqueries;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.ias.repqueries.DirectoryUtils;
import oracle.ias.repqueries.IASConstantsInterface;
import oracle.net.ns.NSProtocol;

public class RepositoryQueries
implements IASConstantsInterface {
    private byte[] key = null;
    private char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void main(String[] args) {
        RepositoryQueries qry = new RepositoryQueries();
        System.out.println("output of getOIDRunning()");
        System.out.println(qry.getOIDRunning("london.us.oracle.com", "3130", "cn=orcladmin", "welcome1", true));
        System.out.println("output of getOIDVersion()");
        System.out.println(qry.getOIDVersion("berlin.us.oracle.com", "3130", "cn=orcladmin", "welcome1", true));
        System.out.println("output of getDIPVersion()");
        System.out.println(qry.getDIPVersion("berlin.us.oracle.com", "3130", "cn=orcladmin", "welcome1", true));
        System.out.println("output of getDBPassword()");
        try {
            System.out.println(qry.getDBPassword("london.us.oracle.com", "3130", "cn=orcladmin", "welcome1", "portal", "asdb.us.oracle.com"));
            System.out.println(qry.getDBConnect("london.us.oracle.com", "3130", "cn=orcladmin", "welcome1", "portal", "5", "asdb.us.oracle.com"));
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println("output of getInfrastructureDatabases()");
        String[] ret = qry.getInfrastructureDatabases("london.us.oracle.com", "3060", "cn=orcladmin", "welcome1", false);
        if (ret != null && ret.length > 0) {
            for (int i = 0; i < ret.length; ++i) {
                System.out.println(ret[i]);
            }
        }
        System.out.println("output of getIASInstances()");
        String[] ret1 = qry.getIASInstances("honolulu.us.oracle.com", "3061", "cn=orcladmin", "ias90412345", true);
        if (ret1 != null && ret1.length > 0) {
            for (int i = 0; i < ret1.length; ++i) {
                System.out.println(ret1[i]);
            }
        }
        try {
            boolean bl = qry.isListenerUp("sun-dried.us.oracle.com", "1521", "iasdb904.us.oracle.com");
            System.out.println("IsListenerUp return value:" + bl);
            bl = qry.isSSOConfigured("honolulu.us.oracle.com", "3061", "cn=orcladmin", "ias90412345", true);
            System.out.println("isSSOConfigured return value:" + bl);
            String ver = qry.getSSOVersion("sydney.us.oracle.com", "3061", "cn=orcladmin", "welcome1", false);
            System.out.println("getSSOVersion return value:" + ver);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public String getSSORunning(String ssoHost, String ssoPort) {
        String ssoStatus = null;
        try {
            URL ssoUrl = new URL("http://" + ssoHost + ":" + ssoPort + "/pls/orasso/orasso.wwsso_app_admin.ssoping");
            BufferedReader in = new BufferedReader(new InputStreamReader(ssoUrl.openStream()));
            ssoStatus = in.readLine();
            in.close();
        }
        catch (Exception e) {
            String in = null;
            return in;
        }
        String ldapHostPort = null;
        String ldapHostName = "LDAP_HOST";
        String ldapPortName = "LDAP_PORT";
        String ssoInfraDBName = "SSO_INFRASTRUCTURE_DB";
        String ldapHost = null;
        String ldapPort = null;
        String ssoInfraDB = null;
        if (ssoStatus != null) {
            try {
                if (ssoStatus.startsWith("SSO server running")) {
                    int startHost = ssoStatus.indexOf(ldapHostName);
                    int startPort = ssoStatus.indexOf(ldapPortName);
                    int startSSOInfraDB = ssoStatus.indexOf(ssoInfraDBName);
                    if (startHost == -1 || startPort == -1 || startSSOInfraDB == -1) {
                        String string = ldapHostPort;
                        return string;
                    }
                    ldapHost = ssoStatus.substring(startHost + ldapHostName.length() + 1, startPort);
                    if (ldapHost != null) {
                        ldapHost = ldapHost.trim();
                    }
                    if ((ldapPort = ssoStatus.substring(startPort + ldapPortName.length() + 1, startSSOInfraDB)) != null) {
                        ldapPort = ldapPort.trim();
                    }
                    if ((ssoInfraDB = ssoStatus.substring(startSSOInfraDB + ssoInfraDBName.length() + 1)) != null) {
                        ssoInfraDB = ssoInfraDB.trim();
                    }
                    ldapHostPort = String.valueOf(ldapHost) + ":" + ldapPort + ":" + ssoInfraDB;
                }
            }
            catch (Exception e) {
                String string = null;
                return string;
            }
        }
        return ldapHostPort;
    }

    public boolean isEmpty(String p_string) {
        if (p_string == null) {
            return true;
        }
        String string = p_string;
        return (string = string.trim()).length() == 0;
    }

    public boolean getOIDRunning(String oidHost, String oidPort, String oidUser, String oidPassword, boolean useSSL) {
        String dn = "cn=iASAdmins, cn=Groups, cn=OracleContext";
        String resoidUser = "";
        if (this.isEmpty(oidHost) || this.isEmpty(oidPort) || this.isEmpty(oidUser) || this.isEmpty(oidPassword)) {
            return false;
        }
        InitialDirContext ctx = null;
        try {
            resoidUser = this.trimSpaces(oidUser, ",");
            ctx = DirectoryUtils.getDirCtx(oidHost, oidPort, oidUser, oidPassword, useSSL);
            String attrname = "uniquemember";
            String valueWithoutSpaces = null;
            String[] attrValues = this.getAttribute(dn, attrname, ctx);
            ctx.close();
            for (int i = 0; i < attrValues.length; ++i) {
                valueWithoutSpaces = this.trimSpaces(attrValues[i], ",");
                if (!valueWithoutSpaces.equalsIgnoreCase(resoidUser)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    public String getDBPassword(String oidHost, String oidPort, String oidUser, String oidPassword, String schemaName, String dbCN) throws Exception {
        String password = null;
        String dn = "orclResourceName=" + schemaName + "," + "orclReferenceName" + "=" + dbCN + "," + "cn=IAS Infrastructure Databases, cn=IAS, cn=Products, cn=OracleContext";
        InitialDirContext ctx = null;
        ctx = DirectoryUtils.getDirCtx(oidHost, oidPort, oidUser, oidPassword, true);
        String attrname = "orclPasswordAttribute";
        String[] attrValues = this.getAttribute(dn, attrname, ctx);
        password = attrValues[0];
        ctx.close();
        return password;
    }

    public String getDBConnect(String oidHost, String oidPort, String oidUser, String oidPassword, String schemaName, String connectFormat, String dbCN) throws Exception {
        String dbConnect = null;
        int format = Integer.parseInt(connectFormat);
        InitialDirContext ctx = null;
        ctx = DirectoryUtils.getDirCtx(oidHost, oidPort, oidUser, oidPassword, true);
        String dn = "orclReferenceName=" + dbCN + "," + "cn=IAS Infrastructure Databases, cn=IAS, cn=Products, cn=OracleContext";
        String[] attArr1 = this.getAttribute(dn, "seealso", ctx);
        String attValue = this.trimSpaces(attArr1[0], ",");
        if (format == 5) {
            dbConnect = attValue;
        } else if (format == 1) {
            dbConnect = "ldaps://" + oidHost + ":" + oidPort + "/" + attValue.substring(attValue.indexOf("=") + 1);
        } else {
            String[] ret = this.getAttribute(attValue, "orclnetdescstring", ctx);
            dbConnect = ret[0];
        }
        ctx.close();
        return dbConnect;
    }

    public String getOIDVersion(String oidHost, String oidPort, String oidUser, String oidPassword, boolean useSSL) {
        String oidVersion = null;
        try {
            InitialDirContext ctx = null;
            ctx = DirectoryUtils.getDirCtx(oidHost, oidPort, oidUser, oidPassword, true);
            String dn = "cn=BASE,cn=oracleschemaversion";
            String[] attrValues = this.getAttribute(dn, "orclproductversion", ctx);
            oidVersion = attrValues[0];
            ctx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return oidVersion;
    }

    public String getDIPVersion(String oidHost, String oidPort, String oidUser, String oidPassword, boolean useSSL) {
        String dipVersion = null;
        try {
            InitialDirContext ctx = null;
            ctx = DirectoryUtils.getDirCtx(oidHost, oidPort, oidUser, oidPassword, true);
            String dn = "cn=Directory Integration Platform,cn=oracleschemaversion";
            String[] attrValues = this.getAttribute(dn, "orclproductversion", ctx);
            dipVersion = attrValues[0];
            ctx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dipVersion;
    }

    private String[] getAttribute(String dn, String attribute, DirContext ctx) {
        Hashtable tbl = this.getAttributes(dn, new String[]{attribute}, ctx);
        return (String[])tbl.get(attribute.toLowerCase());
    }

    private Hashtable getAttributes(String dn, String[] attributes, DirContext ldapContext) {
        Hashtable<String, String[]> tbl = new Hashtable<String, String[]>(attributes.length);
        try {
            Attributes attrs = ldapContext.getAttributes(dn, attributes);
            NamingEnumeration<String> namingEnumeration = attrs.getIDs();
            if (namingEnumeration != null) {
                while (namingEnumeration.hasMoreElements()) {
                    String id = namingEnumeration.next();
                    Attribute att = attrs.get(id);
                    int noOfValues = att.size();
                    NamingEnumeration<?> enum1 = att.getAll();
                    String[] attr1 = new String[noOfValues];
                    int i = 0;
                    if (noOfValues == 1) {
                        attr1[0] = (String)att.get();
                    } else if (enum1 != null) {
                        while (enum1.hasMoreElements()) {
                            attr1[i] = enum1.next().toString();
                            ++i;
                        }
                    }
                    tbl.put(id.toLowerCase(), attr1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tbl;
    }

    private String trimSpaces(String strWithSpaces, String delim) {
        String res = "";
        StringTokenizer strToken = new StringTokenizer(strWithSpaces, delim);
        while (strToken.hasMoreTokens()) {
            res = String.valueOf(res) + strToken.nextToken().trim();
            res = String.valueOf(res) + delim;
        }
        if (res.endsWith(delim)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public String createMidTier(String oidHost, String oidPort, String oidUser, String oidPassword, String midTierCommonName, String midTierPassword) {
        String url = "ldap://" + oidHost + ":" + oidPort;
        Hashtable<String, String> ldapEnv = new Hashtable<String, String>();
        ldapEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapEnv.put("java.naming.provider.url", url);
        ldapEnv.put("java.naming.security.authentication", "simple");
        ldapEnv.put("java.naming.security.principal", oidUser);
        ldapEnv.put("java.naming.security.credentials", oidPassword);
        InitialDirContext ctx = null;
        DirContext result = null;
        try {
            ctx = new InitialDirContext(ldapEnv);
            String dn = "orclApplicationCommonName=" + midTierCommonName + "," + "cn=IAS Instances, cn=IAS, cn=Products, cn=OracleContext";
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute objclass = new BasicAttribute("objectclass");
            objclass.add("top");
            objclass.add("orclApplicationEntity");
            attrs.put(objclass);
            BasicAttribute attr = new BasicAttribute("userpassword");
            attr.add(midTierPassword);
            attrs.put(attr);
            result = ctx.createSubcontext(dn, (Attributes)attrs);
        }
        catch (NamingException e) {
            String string = null;
            return string;
        }
        if (result != null) {
            return midTierCommonName;
        }
        return null;
    }

    public String[] getIASInstances(String oidHost, String oidPort, String oidUser, String oidPassword, boolean useSSL) {
        InitialDirContext ctx = null;
        Object result = null;
        Object[] retValue = null;
        try {
            ctx = DirectoryUtils.getDirCtx(oidHost, oidPort, oidUser, oidPassword, useSSL);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(new String[]{"orclApplicationCommonName"});
            NamingEnumeration<SearchResult> namingEnumeration = ctx.search("cn=IAS Instances, cn=IAS, cn=Products, cn=OracleContext", "objectclass=orclApplicationEntity", ctls);
            Vector<String> iasInstances = new Vector<String>();
            while (namingEnumeration.hasMore()) {
                SearchResult res = namingEnumeration.next();
                Attributes attrs = res.getAttributes();
                Attribute att = attrs.get("orclApplicationCommonName");
                iasInstances.add(att.get().toString());
            }
            retValue = new String[iasInstances.size()];
            iasInstances.copyInto(retValue);
            ctx.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return retValue;
    }

    public String[] getInfrastructureDatabases(String oidHost, String oidPort, String oidUser, String oidPassword, boolean useSSL) {
        InitialDirContext ctx = null;
        Object result = null;
        Vector<String> dbcn = new Vector<String>();
        Vector<String> globalDBName = new Vector<String>();
        String[] retValue = null;
        boolean exception = false;
        try {
            ctx = DirectoryUtils.getDirCtx(oidHost, oidPort, oidUser, oidPassword, useSSL);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(new String[]{"orclReferenceName", "seealso"});
            NamingEnumeration<SearchResult> namingEnumeration = ctx.search("cn=IAS Infrastructure Databases, cn=IAS, cn=Products, cn=OracleContext", "objectclass=orclReferenceObject", ctls);
            while (namingEnumeration.hasMore()) {
                SearchResult res = namingEnumeration.next();
                Attributes attrs = res.getAttributes();
                Attribute att = attrs.get("seealso");
                exception = false;
                try {
                    ctx.lookup(att.get().toString());
                }
                catch (NameNotFoundException ne) {
                    exception = true;
                }
                if (!exception) {
                    dbcn.add(att.get().toString());
                }
                Attribute att1 = attrs.get("orclReferenceName");
                globalDBName.add(att1.get().toString());
            }
            String[] attIds = new String[]{"orclnetdescstring"};
            retValue = new String[dbcn.size()];
            for (int i = 0; i < dbcn.size(); ++i) {
                Attributes attrs = ctx.getAttributes((String)dbcn.elementAt(i), attIds);
                Attribute att = attrs.get("orclnetdescstring");
                String netDescStr = this.trimSpaces(att.get().toString(), "=");
                retValue[i] = String.valueOf(RepositoryQueries.formatGlobalDBName(netDescStr)) + ":" + globalDBName.elementAt(i).toString();
            }
            ctx.close();
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return retValue;
    }

    public String getSSOVersion(String oidHost, String oidPort, String oidUser, String oidPassword, boolean useSSL) {
        InitialDirContext ctx = null;
        String version = null;
        String dn = "orclApplicationCommonName=ORASSO_SSOSERVER,cn=SSO,cn=Products, cn=OracleContext";
        try {
            ctx = DirectoryUtils.getDirCtx(oidHost, oidPort, oidUser, oidPassword, useSSL);
            String attrname = "orclversion";
            String[] attrValues = this.getAttribute(dn, attrname, ctx);
            version = attrValues[0];
            System.out.println(version);
            ctx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public static String formatGlobalDBName(String descStr) {
        String HOST = "HOST";
        String PORT = "PORT";
        String SERVICE_NAME = "SERVICE_NAME";
        String host = RepositoryQueries.getAllValues(descStr, HOST);
        String port = RepositoryQueries.getAllValues(descStr, PORT);
        int loc = descStr.indexOf(SERVICE_NAME);
        String serviceName = RepositoryQueries.getValue(descStr.substring(loc + SERVICE_NAME.length()));
        return String.valueOf(host) + ":" + port + ":" + serviceName;
    }

    private static String getAllValues(String descStr, String searchStr) {
        String res = null;
        String value = null;
        int loc = descStr.indexOf(searchStr);
        while (loc != -1) {
            descStr = descStr.substring(loc + searchStr.length());
            value = RepositoryQueries.getValue(descStr);
            loc = descStr.indexOf(searchStr);
            if (value == null) continue;
            res = res == null ? value : String.valueOf(res) + value;
            res = String.valueOf(res) + ",";
        }
        return RepositoryQueries.trimLastComma(res);
    }

    private static String trimLastComma(String str) {
        int lastCommaIndex = str.lastIndexOf(44);
        return str.substring(0, lastCommaIndex);
    }

    public static String getValue(String str) {
        int i = 1;
        if (str.charAt(0) != '=') {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        while (str.charAt(i) != ')') {
            buf.append(str.charAt(i));
            ++i;
        }
        return buf.toString().trim();
    }

    private String byteToHex(byte[] data) {
        if (data == null) {
            return null;
        }
        int len = data.length;
        StringBuffer buf = new StringBuffer(len * 2);
        for (int pos = 0; pos < len; ++pos) {
            buf.append(this.HEX_DIGIT[data[pos] >>> 4 & 0xF]).append(this.HEX_DIGIT[data[pos] & 0xF]);
        }
        return buf.toString();
    }

    public boolean isListenerUp(String host, String port, String serviceName) throws IOException {
        String connection = "//" + host + ":" + port + "/" + serviceName;
        Properties up = new Properties();
        try {
            NSProtocol ns = new NSProtocol();
            ns.connect(connection, up);
            ns.disconnect();
            boolean bl = true;
            return bl;
        }
        catch (Exception ie) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean isSSOConfigured(String oidHost, String oidPort, String oidUser, String oidPassword, boolean useSSL) {
        String url = "ldap://" + oidHost + ":" + oidPort;
        String dn = "orclApplicationCommonName=ORASSO_SSOSERVER,cn=SSO,cn=Products, cn=OracleContext";
        InitialDirContext ldapContext = null;
        try {
            ldapContext = DirectoryUtils.getDirCtx(oidHost, oidPort, oidUser, oidPassword, useSSL);
            ldapContext.lookup(dn);
            ldapContext.close();
        }
        catch (NamingException e) {
            boolean bl = false;
            return bl;
        }
        return true;
    }
}

